# PYTHON & PASCO: Konstant akselerasjon
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *

# -------------------- Verdier  ---------------------
# Det er ikke nødvendig å sette noen variable nødvendig i denne koden

# ----------------- Spesielle funksjoner ---------------------
# I dette forsøket skal vi derivere to ganger. Derfor
# legger vi enn derivasjon som en egen funksjon her. 
# Funksjonen tar imot tids- og data-listene, og 
# returnerer den deriverte av dataene. 
def derivasjon(tid,data):
    # Funksjon for beregning av den deriverte
    derivert = []            # Lag en tom liste for deriverte data
    n = len(data)            # Finn antall elementer i data-listen
    for i in range(0,n-1):   # Løp gjennom alle elementene
        # Beregn forandringen i data per tid for hvert tidsteg
        derivert.append( (data[i+1] - data[i]) / (tid[i+1] - tid[i]) )
    # Den deriverte i sluttpunktet må beregnes separat for
    # at den deriverte skal ha like mange punkter som 
    # tids-listen og data-listen (n).
    # Vi sier at det siste punktet [n-1] er lik det 
    # nest siste punktet [n-2], med differansen mellom 
    # det nest siste [n-2] og det nest-nest siste [n-3]
    derivert.append( derivert[n-2] + (derivert[n-2]-derivert[n-3]) )
    # Returner den deriverte
    return derivert

# --------------------------- Importering av data ------------------------------
# Lister for lagring av data
tid = []
pos = []

# Innlesing av data fra PASCO
with open('konstant-akselerasjon.txt') as file: # Åpner datafilen
    next(file) # Hopper over overskrift-linjen
    # Løkke over hver linje i datafilen. Hele linjer leses som én tekst.
    for line in file: 
        # Klargjør data for lagring i lister
        line = line.replace(",",".")    # Bytter desimaltegn
        line = line.replace("\n","")    # Fjerner uønskede linjeskift
        line = line.split("\t")         # Splitter streng til liste
        # Tallene i lista står som tekst, konverterer til tall og lagrer
        tid.append(float(line[1]))      # Tidsdata lagres i egen liste
        pos.append(float(line[7]))      # Posisjonsdata lagres i liste

# Velg hvilke tidsintervall av dataene vi skal bruke. 
# Vi tar bort de første 15 punktene
start_tid = 16
slutt_tid = len(tid)-1
tid = tid[start_tid:slutt_tid]
pos = pos[start_tid:slutt_tid]

# ------------------ Beregning av fart og akselerasjon-----------------------
fart = derivasjon(tid,pos) # Finn farten ved å derivere posisjonsdataene
aks = derivasjon(tid,fart) # Finn akselerasjonen ved å derivere farts-dataene

# ---------------------------- Kurvetilpasning ------------------------------
# Lag en kurvetilpasning til posisjonsdataene (annengrads polynom)
A,B,C = polyfit(tid,pos,2)
pos_polyfit = []
for t in tid: 
    pos_polyfit.append(A*t**2 + B*t + C)

#Lag en kurvetilpasning til hastigheten (derivert av posisjonsdata)
D,F = polyfit(tid,fart,1)
fart_polyfit = []
for t in tid: 
    fart_polyfit.append(D*t + F)

# Finn et gjennomstnitt av askelerasjon (dobbelderivert av posisjonsdata)
aks_snitt = []
for t in tid: 
    aks_snitt.append(average(aks))

# Skriv ut ulike estimat av akselerasjon
aks_annengrads_polyfit = 2*A
print("Akselerasjon funnet v.h.a. kurvetilpasning av posisjonsdata: ",
    round(aks_annengrads_polyfit,2))
print("Gj.snitt akselerasjon: ",round(average(aks),2))


# ------------------------ Plotting av resultater ------------------------------
# Data fra PASCO plottes som punkter, regresjon og modell som grafer
# Data plottes i tre paneler over hverandre. 

# POSISJON
subplot(3,1,1)           # Lag første panel (av 3)
plot(tid,pos,".")        # Plotter data som punkter
plot(tid,pos_polyfit)    # Plotter regresjonsgraf
ylabel("Pos. ($m$)")     # y-akse-tittel i panel 1
# Skjul tallene på x-aksen
gca().axes.xaxis.set_ticklabels([])        
# Navngiving av punkter og grafer
legend(["Data","$s=(^1/_2)at^2 + v_0t$"])  

# HASTIGHET
subplot(3,1,2)           # Lag andre panel (av 3)
plot(tid,fart,"+")       # Plotter data som punkter
plot(tid,fart_polyfit)   # Plotter regresjonsgraf
ylabel("Fart ($m/s$)")   # y-akse-tittel i panel 2
# Skjul tallene på x-aksen
gca().axes.xaxis.set_ticklabels([]) 
# Navngiving av punkter og grafer
legend(["Derivert av data","$v=v_0 + at$"]) 

# AKSELERASJON
subplot(3,1,3)           # Lag tredje panel (av 3)
plot(tid,aks,"x")        # Plotter data som punkter
plot(tid,aks_snitt)      # Plotter regresjonsgraf
ylabel("Aks. ($m/s^2$)") # y-akse-tittel i panel 3
xlabel("Tid (s)")        # x-akse-tittel i panel 3
# Navngiving av punkter og grafer
legend(["Dobbelderivert av data","Gjennomsnitt"]) 

# Vis plottet
show() 